// ==UserScript==
// @name         Page Numbering In Canvas
// @namespace    http://tampermonkey.net/
// @version      2025-01-20
// @description  Add or remove page numbers on each page in a module
// @author       Espen Raugstad
// @match        https://uia.instructure.com/courses/*/modules
// @icon         data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    // Your code here...
    /***** Global variables and constant *****/
    const BASE_URL = "https://uia.instructure.com";
    let modules = [];
    let module_items = [];


    addButtons();

    /***** Modal progress dialog *****/
    const dialog = document.createElement("dialog");
    const dialogDiv = document.createElement("div");
    dialog.appendChild(dialogDiv);
    dialogDiv.style.display="flex";
    dialogDiv.style.flexDirection = "column";

    const dialogHeader = document.createElement("h2");
    dialogHeader.innerText = "Fremgang";
    dialogDiv.appendChild(dialogHeader);

    const progressLabel = document.createElement("label");
    progressLabel.setAttribute("for","uia_lll3_module_progression");
    progressLabel.innerText = "Moduler";
    dialogDiv.appendChild(progressLabel);
    const progress = document.createElement("progress");
    progress.setAttribute("id","uia_lll3_module_progression");
    dialogDiv.appendChild(progress);

    const progressLabel2 = document.createElement("label");
    progressLabel2.setAttribute("for","uia_lll3_page_progression");
    progressLabel2.innerText = "Sider i nåværende modul";
    dialogDiv.appendChild(progressLabel2);
    const progress2 = document.createElement("progress");
    progress2.setAttribute("id", "uia_lll3_page_progression");
    dialogDiv.appendChild(progress2);

    document.body.appendChild(dialog);
    /***** ********************* *****/

    /***** Modal MENU dialog *****/
    const menuDialog = document.createElement("dialog");
    const menuDiv = document.createElement("div");
    menuDialog.appendChild(menuDiv);
    menuDiv.style.display = "flex";
    menuDiv.style.flexDirection = "column";
    menuDiv.style.maxWidth = "600px";

    const menuHeader = document.createElement("h2");
    menuHeader.innerText = "Velg plassering av sidetall";
    menuDiv.appendChild(menuHeader);

    const menuDescription = document.createElement("p");
    menuDescription.innerText = "Velg hvor i headeren du vil plassere sidetallene. Posisjonen vil avhenge litt av hvor mange elementer som finnes i headeren allerede. Vær oppmerksom på at dersom antallet elementer er lik et oddetall, så vil plassering i midten enten havne til venstre eller høyre for selve midten avhengig av hva du velger. Dersom antallet er et partall vil begge valgene gjøre at det havner i midten.";
    menuDiv.appendChild(menuDescription);

    const selectPlacement = document.createElement("select");
    selectPlacement.innerHTML = `<option value="">-- Velg plassering --</option>
    <option value = "V">Venstre</option>
    <option value = "VM">Midten (venstre ved oddetall)</option>
    <option value = "HM">Midten (høyre ved oddetall)</option>
    <option value = "H">Høyre</option>`;
    menuDiv.appendChild(selectPlacement);

    const buttonsDiv = document.createElement("div");
    buttonsDiv.style.display = "flex";
    buttonsDiv.style.justifyContent = "space-between";
    menuDiv.appendChild(buttonsDiv);

    const okBtn = document.createElement("button");
    okBtn.innerText = "Sett inn";
    okBtn.addEventListener("click", ()=>{
        let position = selectPlacement.value;
        if(!position){
            alert("Du må velge en plassering for å kunne sette inn sidetall.");
            return;
        }
        menuDialog.close();
        addPageNumbers(position);
    });
    buttonsDiv.appendChild(okBtn);

    const cancelBtn = document.createElement("button");
    cancelBtn.innerText = "Avbryt";
    cancelBtn.addEventListener("click", ()=>{menuDialog.close();});
    buttonsDiv.appendChild(cancelBtn);

    document.body.appendChild(menuDialog);
    /***** ********************* *****/


    function addButtons(){
        const navBar = document.querySelector(".header-bar-right__buttons");

        const addPageNumbersButton = document.createElement("button");
        addPageNumbersButton.innerText = "Legg til sidetall";
        navBar.appendChild(addPageNumbersButton);
        //addPageNumbersButton.addEventListener("click", addPageNumbers);
        addPageNumbersButton.addEventListener("click", ()=>{
            menuDialog.showModal();
        });

        const removePageNumbersButton = document.createElement("button");
        removePageNumbersButton.innerText = "Fjern sidetall";
        navBar.appendChild(removePageNumbersButton);
        removePageNumbersButton.addEventListener("click", removePageNumbers);
    }


    async function removePageNumbers(){
        await getCourseModules(`${BASE_URL}/api/v1/courses/${ENV.course_id}/modules`);
        dialog.showModal();
        progress.setAttribute("max", modules.length);
        progress.value=0;
        for(const [i, module] of modules.entries()){
            let module_id = module.id;
            module_items = [];
            await getModuleItems(`${BASE_URL}/api/v1/courses/${ENV.course_id}/modules/${module_id}/items`);

            let moduleTotalPages = module_items.length;
            progress2.setAttribute("max", moduleTotalPages);
            progress2.value=0;
            // Go through all module items and get pages
            for(const [j, item] of module_items.entries()){
                if(item.type === "Page"){
                    let page = await getModulePage(item.url);
                    let pageTitle = item.title;
                    let oldPageBody = page.body;

                    // Create a temporary div with the old content to select and remove page numbers from
                    let tmpDiv = document.createElement("div");
                    tmpDiv.style.display="none";
                    tmpDiv.setAttribute("id", "fsgdasgfgagsagsgafdgssd");
                    tmpDiv.innerHTML = oldPageBody;
                    document.body.appendChild(tmpDiv);

                    // Get all instances of pagenumbers
                    let pn = Array.from(tmpDiv.querySelectorAll("#uia_lll3_pageNumber"));
                    // Get any potential empty placeholder paragraphs.
                    let emptyPs = Array.from(tmpDiv.querySelectorAll(".uia_lll3_empty_paragraph"));

                    if(pn.length>0 || emptyPs.length > 0){
                        // Remove all instances of pagenumbers
                        if(pn.length > 0){
                            for(const number of pn){
                                number.remove();
                            }
                        }

                        if(emptyPs.length > 0){
                            for(const p of emptyPs){
                                p.remove();
                            }
                        }

                        // The new body to update the page with
                        let newBody = tmpDiv.innerHTML;

                        let updated = await updatePage(item.url, newBody, pageTitle);
                    }

                    // Remove temporary div from page
                    tmpDiv.remove();
                }
                progress2.value = j;
            }
            progress.value = i;
        }
        dialog.close();
    }

    async function addPageNumbers(position){
        await getCourseModules(`${BASE_URL}/api/v1/courses/${ENV.course_id}/modules`);
        // Go through each module and get items
        dialog.showModal();
        progress.setAttribute("max", modules.length);
        progress.value=0;

        for(const [i, module] of modules.entries()){
            module_items = [];
            let module_id = module.id;
            await getModuleItems(`${BASE_URL}/api/v1/courses/${ENV.course_id}/modules/${module_id}/items`);
            let moduleTotalPages = module_items.length;
            progress2.setAttribute("max", moduleTotalPages);
            progress2.value=0;
            // Go through all module items and get pages
            for(const [j,item] of module_items.entries()){
                if(item.type === "Page"){
                    let page = await getModulePage(item.url);
                    let pageTitle = item.title;
                    let modulePageNumber = item.position;
                    let oldPageBody = page.body;
                    let newPageBody = parsePage(page, modulePageNumber, module_items.length, position);

                    if(newPageBody){
                        let updated = await updatePage(item.url, newPageBody, pageTitle);
                    }
                }
                progress2.value = j;
            }
            progress.value = i;
        }
        dialog.close();
    }

    function parsePage(page, pageNumber, pageTotal, position){
        const parser = new DOMParser();
        const doc = parser.parseFromString(page.body, 'text/html');
        console.log("Parsing");
        let header = doc.querySelector("header");
        // If there is no header, or the header is not "our" header, don't parse.
        if(!header || !(header.classList.contains("justify-between") && header.classList.contains("border-b"))){
            return false;
        }
        // Check to see if page numbers already exists
        let existingPageNumbers = doc.querySelector("#uia_lll3_pageNumber");

        if(existingPageNumbers){
            // Update existing page numbers
            existingPageNumbers.innerHTML = `<span style="color:var(--sd-clyn0bfq0000hmoqy6jykmw89-nlka);"><em><strong>Side ${pageNumber} av ${pageTotal}</strong></em><span>`;
        } else{
            let pageNumberParagraph = document.createElement("p");
            pageNumberParagraph.setAttribute("id","uia_lll3_pageNumber");
            pageNumberParagraph.classList.add("md:text-base","text-xs");
            pageNumberParagraph.innerHTML = `<span style="color:var(--sd-clyn0bfq0000hmoqy6jykmw89-nlka);"><em><strong>Side ${pageNumber} av ${pageTotal}</strong></em><span>`;

            // TODO
            // Calculate position based on number of items in header and selected position

            // Number of elements in the header
            let n = header.children.length;
            // Placeholder paragraph to clone
            let placeP = document.createElement("p");
            placeP.innerHTML = "&nbsp;";
            placeP.classList.add("uia_lll3_empty_paragraph");

            console.log(n);
            if(n === 0){
                switch (position){
                    case "V":
                        header.appendChild(pageNumberParagraph);
                        break;
                    case "VM":
                        // Fallthrough
                    case "HM":
                        header.append(placeP.cloneNode(true), pageNumberParagraph, placeP.cloneNode(true));
                        break;
                    case "H":
                        header.appendChild(placeP.cloneNode(true));
                        header.appendChild(pageNumberParagraph);
                        break;
                }
            } else if(n === 1){
                switch(position){
                    case "V":
                        header.insertAdjacentElement("afterbegin", pageNumberParagraph);
                        break;
                    case "VM":
                        // Fallthrough
                    case "HM":
                        header.append(pageNumberParagraph, placeP.cloneNode(true));
                        break;
                    case "H":
                        header.appendChild(pageNumberParagraph);
                        break;
                }
            } else {
                // Start by getting the element which we want to place the pagenumber "beforebegin"
                let beforeElementNumber = getInsertBeforeElementNumber(position, n);
                console.log("Before element number: ");
                console.log(beforeElementNumber);

                if(beforeElementNumber === -1){
                    header.appendChild(pageNumberParagraph);
                } else {
                    let beforeElement = header.children[beforeElementNumber];
                    beforeElement.insertAdjacentElement("beforebegin", pageNumberParagraph);
                }



            }

            //let insertPosition = getInsertPosition(position, header.children.length);

            /*             if(header.children.length > 0){
                header.children[0].insertAdjacentElement("afterend", pageNumberParagraph);
            } else {
                header.appendChild(pageNumberParagraph);
            }
            console.log("Document");
            console.log(doc.body); */
        }
        return doc.body.innerHTML;
    }

    function getInsertBeforeElementNumber(position, n){
        // n is the number of elements in the header

        if(position === "V"){
            return 0;
        }
        if(position === "H"){
            return -1;
        }
        if(position === "VM"){
            return n%2 === 0 ? n/2 : (n-1)/2;
        }
        if(position === "HM"){
            return n%2 === 0 ? n/2 : (n+1)/2;
        }


    }

    async function getCourseModules(url){
        console.log("Fetching modules");
        let res = await fetch(url);
        if(res.status === 200){
            let data = await res.json();
            modules = modules.concat(data);
            let nextLink = findNextLink(res);
            if(nextLink){
                await getCourseModules(nextLink);
            }
        } else {
            console.error("Unable to retrieve modules");
        }
    }

    async function getModuleItems(url){
        let res = await fetch(url);
        console.log(res);
        if(res.status === 200){
            let data = await res.json();
            module_items = module_items.concat(data);
            let nextLink = findNextLink(res);
            if(nextLink){
                await getModuleItems(nextLink);
            }
        } else {
            console.error("Unable to retrieve module items");
        }
    }

    async function getModulePage(url){
        //let apiUrl = `/api/v1/courses/${ENV.course_id}/pages/page_id:${page_id}`;
        let res = await fetch(url);
        if(res.status === 200){
            let data = await res.json();
            return data;
        } else {
            console.error("Unable to retrieve module page");
        }
    }

    async function updatePage(url, body, title){
        //let urlWithParams = url + "?wiki_page[body]=" + body;
        let res = await fetch(url, {
            method: 'PUT',
            headers: {
                "Content-Type": "application/json",
                'X-CSRF-Token': CSRFtoken(),
            },
            body: JSON.stringify({
                "wiki_page": {
                    "title": title,
                    "body": body,
                }
            }),
        });
        if(res.status === 200){
            return true;
        } else {
            console.log("Unable to update page");
            return false;
        }
    }


    /****** UTILITIES ******/
    const CSRFtoken = function() {
        return decodeURIComponent((document.cookie.match('(^|;) *_csrf_token=([^;]*)') || '')[2])
    }

    function findNextLink(results){
        let responseHeaders = [...results.headers];
        let linkHeader = responseHeaders.find((el) => el[0].toLowerCase() === "link");
        let textArray = linkHeader[1].split(",");
        // Go through and see if we find a next link
        for(const link of textArray){
            let [url, rel] = link.split(";");
            if(rel.includes("next")){
                // Remove the < and > from start and end.
                return url.substring(1,url.length - 1);
            }
        }
        return false; // No next-link was found.
    }

})();